 ; Ŀ
 ;   Hangman - find and erase any blocks with embedded single character    
 ;   text strings including all the letters in the word "ENGINEER".        
 ;   (Specifically beaver stamps.)                                         
 ;   Also erases Permit stamps based on finding the string "Permit To      
 ;   Practice."                                                            
 ;   Copyright 1997, 2006, 2007 by Rocket Software Ltd.                    
 ;   Efficiency isn't everything, compared to other factors.               
 ; 

 ; Ŀ
 ;   Bok - see if a block definition is an inserted non-Xrefed block       
 ;   without attributes which is not anonymous or externally dependent.    
 ;   Takes one argument, a block data list from the block tables.          
 ;   Returns T if the block might be a beaver stamp, otherwise nil.        
 ; 
 (DEFUN BOK (bldat / sevent)
  (setq sevnt (cdr (assoc 70 bldat)))
  (if (and (= 0 (logand 1 sevnt))    ; not anonymous
 ; Ŀ
 ;   The next line is commented out because it is possible to have a       
 ;   block which is (70 . 2) but which does not have attributes.           
 ;   This may be a drawing error but audit doesn't catch it.               
 ;   Also the presence of attributes isn't really relevant - some permit   
 ;   and beaver stamps have them.                                          
 ; 
;           (= 0 (logand 2 sevnt))    ; no attributes
           (= 0 (logand 4 sevnt))    ; not an xref
           (= 0 (logand 16 sevnt)))  ; not an externally dependent
       T ()))
 ; Ŀ
 ;   Bok end.                                                              
 ; 

 ; Ŀ
 ;   Gobo - make current the space occupied by an entity.                  
 ;   Arguments: Enam, the entity name.                                     
 ;   Calls nothing, Returns nothing.                                       
 ; 
 (DEFUN GOBO (enam / ctab)
  (setq ctab (cdr (assoc 410 (entget enam))))
 ; Ŀ
 ;   Set the space containing the entity to be current.                    
 ; 
  (setvar "ctab" ctab)
 ; Ŀ
 ;   If it is not in the Model tab, make sure we are in paper space.       
 ; 
  (if (/= (getvar "ctab") "Model") (command ".pspace"))
 (princ))
 ; Ŀ
 ;   Gobo end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Hang - see if a block contains the single-character text   
 ;   subentities required to make the word Engineer.  Takes the first      
 ;   subentity list from the block definition as its sole argument,        
 ;   returns T if all characters are present, else ().                     
 ; 
 (DEFUN HANG (subnam / len entt txt strlst subnam n1 n2 n3 n4 n5 n6 n7 n8)
  (setq len 1)
  (while (and subnam (= len 1))
         (setq entt (entget subnam))
         (if (and (= (cdr (assoc 0 entt)) "TEXT")
                  (setq len (strlen (setq txt (cdr (assoc 1 entt)))))
                  (member txt (list "E" "N" "G" "I" "R")))
             (setq strlst (append strlst (list txt))))
         (setq subnam (entnext subnam)))
  (setq look "--------")
  (while (and (setq txt (car strlst))
              (/= look "ENGINEER"))
         (setq strlst (cdr strlst))
         (cond ((and (null n1) (= txt "E"))
                (setq n1 t)
                (command "delay" 200)
                (setq look (strcat txt (substr look 2))))
               ((and (null n2) (= txt "N"))
                (setq n2 t)
                (command "delay" 200)
                (setq look (strcat (substr look 1 1) txt (substr look 3))))
               ((and (null n3) (= txt "G"))
                (setq n3 t)
                (command "delay" 200)
                (setq look (strcat (substr look 1 2) txt (substr look 4))))
               ((and (null n4) (= txt "I"))
                (setq n4 t)
                (command "delay" 200)
                (setq look (strcat (substr look 1 3) txt (substr look 5))))
               ((and (null n5) (= txt "N"))
                (setq n5 t)
                (command "delay" 200)
                (setq look (strcat (substr look 1 4) txt (substr look 6))))
               ((and (null n6) (= txt "E"))
                (setq n6 t)
                (command "delay" 200)
                (setq look (strcat (substr look 1 5) txt (substr look 7))))
               ((and (null n7) (= txt "E"))
                (setq n7 t)
                (command "delay" 200)
                (setq look (strcat (substr look 1 6) txt (substr look 8))))
               ((and (null n8) (= txt "R"))
                (setq n8 t)
                (command "delay" 200)
                (setq look (strcat (substr look 1 7) txt))))
         (grtext -1 look))
  (if (and n1 n2 n3 n4 n5 n6 n7 n8) t ()))
 ; Ŀ
 ;   Subroutine Hang end.                                                  
 ; 

 ; Ŀ
 ;   Sprase - erase things which may be in different spaces.               
 ;   Arguments: Ss, a slelection set of stuff to erase.                    
 ;   Calls Gobo, Returns nothing.                                          
 ; 
 (DEFUN SPRASE (ss / num enam)
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (gobo enam)
         (command ".erase" enam ""))
 (princ))
 ; Ŀ
 ;   Sprase end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Tang - see if a block contains any text string in a list.  
 ;   Arguments: Strls, a list of text strings.                             
 ;              Subnam, the 1st subentity list from the block definition.  
 ;   Returns T if a string was found, else ().                             
 ; 
 (DEFUN TANG (strls subnam / entt txt subnam found)
  (while (and subnam (null found))
         (setq entt (entget subnam))
         (if (and (= (cdr (assoc 0 entt)) "TEXT")
                  (setq txt (cdr (assoc 1 entt)))
                  (member txt strls))
             (setq found t))
         (setq subnam (entnext subnam)))
 found)
 ; Ŀ
 ;   Subroutine Tang end.                                                  
 ; 

 ; Ŀ
 ;   Hangman.                                                              
 ; 
 (DEFUN C:HANGMAN (/ nokill reww boxes num bldat blnam sube ss len)
  (setq nokill (list "TB" "MAINTB" "GELTITLE" "WIRELINE" "PERMALTA"
                     "PQPERMIT" "REVTB" "INTRAGAZ" "PLOTDATE" "REVTRI"
                     "FIELDTB" "1WIRETAG" "TITLEBLK" "N-ARROW"
                     "P-END" "JBSHIELD" "3WSHIELD" "2WSHIELD" "2WCTSHLD"
                     "T2A-3"))
  (setq reww T)
  (setq boxes (getvar "screenboxes"))
  (setq num 1)
  (while (setq bldat (tblnext "block" reww))
         (setq reww ())
         (grtext num (setq blnam (cdr (assoc 2 bldat))))
         (grtext (1+ num) " ")
         (setq num (1+ num))
         (if (> num boxes) (setq num 0))
         (setq sube (cdr (assoc -2 bldat)))
         (if (and (not (member (strcase blnam) nokill))
                  (bok bldat)
                  (or (hang sube) (tang '("PERMIT TO PRACTICE") sube))
                  (setq ss (ssget "X" (list (cons 2 blnam)))))
             (progn
                  (setq len (itoa (sslength ss)))
                  (write-line (strcat "Erasing " len " " blnam
                                      (if (= len "1") "." "s.")))
                  (sprase ss))))
 ; Ŀ
 ;   Clean up screen menus and end.                                        
 ; 
  (grtext)
 (princ))